﻿using System;

namespace algocs_comparable
{
    class Person : IComparable<Person>
    {
        private string firstName, secondName, lastName;
        private DateTime birthDate;

        public string FirstName
        {
            get { return firstName; }
        }

        public string SecondName
        {
            get { return secondName; }
        }

        public string LastName
        {
            get { return lastName; }
        }

        public DateTime BirthDate
        {
            get { return birthDate; }
        }

        public Person(string firstName, string secondName, string lastName, DateTime birthDate)
        {
            this.firstName = firstName;
            this.secondName = secondName;
            this.lastName = lastName;
            this.birthDate = birthDate;
        }

        public override string ToString()
        {
            return string.Format("{0}, {1} {2} ({3:d})", lastName, firstName, secondName, birthDate);
        }

        public int CompareTo(Person other)
        {
            int cmp = string.Compare(lastName, other.lastName);
            if (cmp == 0)
            {
                cmp = string.Compare(firstName, other.firstName);
                if (cmp == 0)
                    cmp = string.Compare(secondName, other.secondName);
            }
            return cmp;
        }
    }
}
