﻿using System;
using System.Collections.Generic;

namespace algocs_comparable
{
    // Делаем класс, реализующий интерфейс IComparer.
    // Нажимаем правой кнопкой мыши на IComparer и выбираем пункт меню "Implement interface":
    // создаются дефолтные реализации всех методов, которые требует этот интерфейс
    class PersonComparerByDate : IComparer<Person>
    {
        // Компаратор должен реализовать только 1 метод: Compare(x, y).
        // В этом классе мы дополнительно реализуем подсчет количества выполненных сравнений,
        // что может быть полезно, если мы хотим сравнить разные алгоритмы по количеству сравнений
        public int Compare(Person x, Person y)
        {
            // Автоматически сгенеренная реализация просто бросает exception.
            //throw new NotImplementedException();

            // Вместо этого пишем свою собственную реализацию сравнения
            count++;
            return DateTime.Compare(x.BirthDate, y.BirthDate);
        }

        private int count;
        public int Count
        {
            get { return count; }
        }

        public void Reset()
        {
            count = 0;
        }
    }
}
