﻿using System;

namespace algocs_comparable
{
    class Program
    {
        static void Main(string[] args)
        {
            // массив объетов типа Person
            var persons = new Person[8];

            persons[0] = new Person("Alan", "Mathison", "Turing", new DateTime(1912, 06, 23));
            persons[1] = new Person("Edsger", "Wybe", "Dijkstra", new DateTime(1930, 05, 11));
            persons[2] = new Person("Donald", "Ervin", "Knuth", new DateTime(1938, 01, 10));
            persons[3] = new Person("Charles", "Antony Richard", "Hoare", new DateTime(1934, 01, 11));
            persons[4] = new Person("Robert", "Endre", "Tarjan", new DateTime(1948, 04, 30));
            persons[5] = new Person("Claude", "Elwood", "Shannon", new DateTime(1916, 04, 30));
            persons[6] = new Person("John", "von", "Neumann", new DateTime(1903, 12, 28));
            persons[7] = new Person("Richard", "Manning", "Karp", new DateTime(1935, 01, 03));

            // сортируем с использованием дефолтного метода сравнения (Person реализует интерфейс IComparable) 
            Array.Sort(persons);
            foreach (Person p in persons)
                Console.WriteLine(p);

            Console.WriteLine("-----");

            // сортируем с использованием специального компаратора, чтобы отсортировать по дате рождения
            var c = new PersonComparerByDate();
            Array.Sort(persons, c);
            foreach (Person p in persons)
                Console.WriteLine(p);
            // наш компаратор еще умеет считать количество сравнений
            Console.WriteLine("    Количество сравнений: {0}", c.Count);
        }
    }
}
