﻿using System;

namespace algocs_hash
{
    // Для хранения объектов пользовательского класса в хеш-таблице
    // необходимо переопределить методы equals() и hashCode().
    class Person : IComparable<Person>
    {
        private string firstName, secondName, lastName;
        private DateTime birthDate;

        public string FirstName
        {
            get { return firstName; }
        }

        public string SecondName
        {
            get { return secondName; }
        }

        public string LastName
        {
            get { return lastName; }
        }

        public DateTime BirthDate
        {
            get { return birthDate; }
        }

        public Person(string firstName, string secondName, string lastName, DateTime birthDate)
        {
            this.firstName = firstName;
            this.secondName = secondName;
            this.lastName = lastName;
            this.birthDate = birthDate;
        }

        public override string ToString()
        {
            return string.Format("{0}, {1} {2} ({3:d})", lastName, firstName, secondName, birthDate);
        }

        public int CompareTo(Person other)
        {
            int cmp = string.Compare(lastName, other.lastName);
            if (cmp == 0)
            {
                cmp = string.Compare(firstName, other.firstName);
                if (cmp == 0)
                    cmp = string.Compare(secondName, other.secondName);
            }
            return cmp;
        }

        public override bool Equals(object obj)
        {
            if (obj == this)
                return true;

            // приводим к типу Person одним из двух способов

            // оператор is - проверка типа (аналог instanceof в Java) + ugly cast
            //if (!(obj is Person))
            //    return false;
            //var p = (Person)obj;

            // оператор as - безопасное приведение типа, т.е. если obj = null
            // или obj не является наследником Person, то (obj as Person) вернет null
            var p = obj as Person;
            if (p == null)
                return false;

            return
                firstName == p.firstName &&
                secondName == p.secondName &&
                lastName == p.lastName &&
                birthDate == p.birthDate;
        }

        public override int GetHashCode()
        {
            int hash = (firstName == null ? 0 : firstName.GetHashCode());
            hash = 31 * hash + (secondName == null ? 0 : secondName.GetHashCode());
            hash = 31 * hash + (lastName == null ? 0 : lastName.GetHashCode());
            // DateTime - структура (struct), поэтому не может иметь значение null
            hash = 31 * hash + birthDate.GetHashCode();
            return hash;
        }
    }
}
