﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace algocs_hash
{
    class Program
    {
        static void Main(string[] args)
        {
            // учимся сравнивать строки
            string s1 = "Hello";
            string s2 = "Hell";
            s2 = s2 + "o";

            // сравнивать строки в C# можно как с помощью == так и с помощью Equals
            Console.WriteLine("s1 == s2: {0}", s1 == s2);
            Console.WriteLine("s1.Equals(s2): {0}", s1.Equals(s2));
            Console.WriteLine("object.Equals(s1,s2): {0}", object.Equals(s1,s2));
            // если забыть о том, что это строки и сравнивать как объекты, то можно понять, что они разные
            Console.WriteLine("(object)s1 == (object)s2: {0}", (object)s1 == (object)s2);

            // когда нужно производить много операций со строкой (складывать куски, брать подстроки, переворачивать...)
            // рекомендуется использовать StringBuilder
            StringBuilder sb = new StringBuilder();
            sb.Append("H").Append("el").Append("lo");
            string s3 = sb.ToString();
            Console.WriteLine("StringBuilder: {0}", s3);

            // метод Intern() возвращает ссылку на строку из пула строк.
            // пул гарантирует, что две строки с одинаковым значением будут представлены одним объектом.
            string s4 = String.Intern(s2);
            // если забыть о том, что это строки и сравнивать как объекты, то можно увидеть, что на самом деле одинаковые
            Console.WriteLine("(object)s1 == (object)s4: {0}", (object)s1 == (object)s4);


            // создаем объекты нашего класса
            Person person1 = new Person("Alan", "Mathison", "Turing", new DateTime(1912, 06, 23));
            Person person2 = new Person("Edsger", "Wybe", "Dijkstra", new DateTime(1930, 05, 11));
            Person person3 = new Person("Donald", "Ervin", "Knuth", new DateTime(1938, 01, 10));

            Person personX = new Person("Alan", "Mathison", "Turing", new DateTime(1912, 06, 23));

            // добавляем созданные объекты в хеш-таблицу
            HashSet<Person> set = new HashSet<Person>();
            set.Add(person1); // в хеш-таблице 1 объект
            set.Add(person2); // в хеш-таблице 2 объекта
            set.Add(person3); // в хеш-таблице 3 объекта
            set.Add(person1); // повторное добавление объекта не изменяет содержимое хеш-таблицы
                              // (по-прежнему 3 объекта)
            set.Add(personX); // добавляем еще одного Алана Тьюринга. если Equals() и GetHashCode()
                              // реализованы правильно - содержимое хеш-таблицы не изменится

            foreach (Person p in set)
                Console.WriteLine(p);
        }
    }
}
