﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace algocs_hello
{
    class Program
    {
        // Первая программа:
        //  1. Ввод-вывод текста.
        //  2. Возможности форматирования на примере вывода значения DateTime в различных форматах.
        //     Полное описание опций форматирования см. в документации MSDN:
        //     https://msdn.microsoft.com/ru-ru/library/system.string.format(v=vs.110).aspx
        //  3. Чтение целочисленных массива из консоли.
        //     К сожалению, читать числовые массивы из консоли или текстового файла не очень удобно.
        //     Было бы полезно иметь аналог класса Parser из Java.
        //  4. Реализация сортировки вставками.
        //  5. Задание значений массива в коде программы.
        //  6. 
        static void Main(string[] args)
        {
            // спрашиваем имя пользователя и приветсвуем его
            Console.Write("What is your name? ");
            string name = Console.ReadLine();
            Console.WriteLine("Hello, {0}!", name);

            // выводим текущее время в различных форматах
            DateTime now = DateTime.Now;
            string text = string.Format("It is {0}, or in a different format {0:HH:mm:ss} of {0:d}", now);
            Console.WriteLine(text);

            // считываем размер массива
            Console.Write("Введите размер массива: ");
            string line = Console.ReadLine();
            int n = Convert.ToInt32(line);

            // считываем элементы массива
            Console.Write("Введите {0} целых чисел: ", n);
            int[] a = new int[n];
            int i = 0;
            while (true)
            {
                line = Console.ReadLine();
                string[] parts = line.Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
                for (int j = 0; j < parts.Length; j++)
                {
                    a[i++] = Convert.ToInt32(parts[j]);
                    if (i >= n)
                        break;
                }
                if (i >= n)
                    break;
            }

            // вызываем на метод сортировки (сортировка вставками) и выводим отсортированный массив
            Sort(a);
            for (i = 0; i < a.Length; i++)
                Console.Write("{0} ", a[i]);
            Console.WriteLine();

            // задаем массив строк в программе
            string[] b = new string[] { "One", "Two", "Three", "Четыре", "Пять", "Шесть", "Seven", "Eight" };

            // сортируем стандартным методом (в алфавитном порядке) и выводим отсортированный массив
            Array.Sort(b);
            for (i = 0; i < b.Length; i++)
                Console.Write("{0} ", b[i]);
            Console.WriteLine();
        }

        private static void Sort(int[] a)
        {
            int N = a.Length;
            for (int i = 1; i < N; i++)
            {
                int j = i, t = a[j];
                while (j > 0 && t < a[j - 1])
                {
                    a[j] = a[j - 1];
                    j--;
                }
                a[j] = t;
            }
        }
    }
}
