﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace algocs_paint
{
    public partial class ViewCtrl : UserControl
    {
        static Brush brushBack = new SolidBrush(Color.White);
        static Brush brushPoint = new SolidBrush(Color.Black);
        static Pen penVertical = new Pen(Color.Red);
        static Pen penHorizontal = new Pen(Color.Blue);

        public ViewCtrl()
        {
            InitializeComponent();
            DoubleBuffered = true;
        }

        private float minX = 0, maxX = 1;
        private float minY = 0, maxY = 1;
        private int MARGIN_X = 8, MARGIN_Y = 8;

        private PointF[] points;
        public void SetPoints(PointF[] points)
        {
            this.points = points;
            Invalidate();
        }

        private int numLines;
        public void SetNumLines(int n)
        {
            numLines = n;
            Invalidate();
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            var g = e.Graphics;
            g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
            //g.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.High;

            var rect = ClientRectangle;
            g.FillRectangle(brushBack, rect);

            if (points != null)
            {
                for (int i = 0; i < points.Length; i++)
                {
                    int x = (int)Math.Round((rect.Width - 2 * MARGIN_X) * (points[i].X - minX) / (maxX - minX));
                    int y = (int)Math.Round((rect.Height - 2 * MARGIN_Y) * (points[i].Y - minY) / (maxY - minY));
                    //float x = (rect.Width - 2 * MARGIN_X) * (points[i].X - minX) / (maxX - minX);
                    //float y = (rect.Height - 2 * MARGIN_Y) * (points[i].Y - minY) / (maxY - minY);

                    if (i < numLines)
                    {
                        if (i % 2 == 0)
                            g.DrawLine(penVertical, x, 0, x, rect.Height);
                        else
                            g.DrawLine(penHorizontal, 0, y, rect.Width, y);
                    }

                    var rectP = new RectangleF(x - 3, y - 3, 6, 6);
                    g.FillEllipse(brushPoint, rectP);
                }
            }
        }
    }
}
