﻿using System;
using System.Collections;
using System.Collections.Generic;

namespace algocs_stack
{
    // Реализуем интерфейс IEnumerable
    // (в GetEnumerator мы возвращаем наш класс, реализующий IEnumerator)
    class Stack3<T> : IEnumerable<T>
    {
        const int MIN_SIZE = 4;

        int count;
        T[] items;

        public Stack3()
        {
            items = new T[MIN_SIZE];
        }

        public Stack3(int capacity)
        {
            items = new T[capacity];
        }

        private void Resize(int n)
        {
            if (n < MIN_SIZE)
                return;
            T[] temp = new T[n];
            for (int i = 0; i < count; i++)
                temp[i] = items[i];
            items = temp;
        }

        public void Push(T x)
        {
            if (count == items.Length)
                Resize(items.Length * 2);
            items[count++] = x;
        }

        public T Pop()
        {
            if (count == 0)
                throw new Exception("Stack is empty");
            T x = items[--count];
            items[count] = default(T);
            if (count <= items.Length / 4)
                Resize(items.Length / 2);
            return x;
        }

        public T Peek()
        {
            if (count == 0)
                throw new Exception("Stack is empty");
            return items[count - 1];
        }

        public bool IsEmpty
        {
            get
            {
                return count == 0;
            }
        }

        public int Size
        {
            get
            {
                return count;
            }
        }

        public int Capacity
        {
            get
            {
                return items.Length;
            }
            set
            {
                if (value < count)
                    throw new Exception("Capacity is not enough");
                Resize(value);
            }
        }

        class StackEnumerator : IEnumerator<T>
        {
            int index;
            Stack3<T> stack;

            public StackEnumerator(Stack3<T> stack)
            {
                this.stack = stack;
                index = stack.count;
            }

            public T Current
            {
                get { return stack.items[index]; }
            }

            object IEnumerator.Current
            {
                get { return stack.items[index]; }
            }

            public void Dispose()
            {
            }

            public bool MoveNext()
            {
                index--;
                return index >= 0;
            }

            public void Reset()
            {
                throw new NotImplementedException();
            }
        }

        public IEnumerator<T> GetEnumerator()
        {
            return new StackEnumerator(this);
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }
    }
}
