﻿using System;

namespace algocs_stack
{
    // Реализация стека int на основе массива
    class Stack1
    {
        // Не будем делать размер массива меньше, чем MIN_SIZE 
        const int MIN_SIZE = 4;

        int count;
        int[] items;

        public Stack1()
        {
            items = new int[MIN_SIZE];
        }

        public Stack1(int capacity)
        {
            items = new int[capacity];
        }

        // При попытке добавить элемент в стек, когда массив полностью заполнен - увеличиваем размер массива в 2 раза.
        // Когда реальное количество элементов становится (размер массива)/4 - уменьшаем массив в 2 раза.
        private void Resize(int n)
        {
            if (n < MIN_SIZE)
                return;
            int[] temp = new int[n];
            for (int i = 0; i < count; i++)
                temp[i] = items[i];
            items = temp;
        }

        public void Push(int x)
        {
            if (count == items.Length)
                Resize(items.Length * 2);
            items[count++] = x;
        }

        public int Pop()
        {
            if (count == 0)
                throw new Exception("Stack is empty");
            int x = items[--count];
            if (count <= items.Length / 4)
                Resize(items.Length / 2);
            return x;
        }

        public int Peek()
        {
            if (count == 0)
                throw new Exception("Stack is empty");
            return items[count - 1];
        }

        public bool IsEmpty
        {
            get
            {
                return count == 0;
            }
        }

        public int Size
        {
            get
            {
                return count;
            }
        }

        public int Capacity
        {
            get
            {
                return items.Length;
            }
            set
            {
                if (value < count)
                    throw new Exception("Capacity is not enough");
                Resize(value);
            }
        }
    }
}
