﻿using System;

namespace algocs_stack
{
    // Реализация стека как обобщенного типа (generic),
    // т.е. контейнера, способного хранить элементы указанного типа T 

    // Обратите внимание на присваивание default(T) элементу массива в методе Pop().
    // Это необходимо для избежания утечки памяти (memory leak), когда T - ссылочный тип.
    class Stack2<T>
    {
        const int MIN_SIZE = 4;

        int count;
        T[] items;

        public Stack2()
        {
            items = new T[MIN_SIZE];
        }

        public Stack2(int capacity)
        {
            items = new T[capacity];
        }

        private void Resize(int n)
        {
            if (n < MIN_SIZE)
                return;
            T[] temp = new T[n];
            for (int i = 0; i < count; i++)
                temp[i] = items[i];
            items = temp;
        }

        public void Push(T x)
        {
            if (count == items.Length)
                Resize(items.Length * 2);
            items[count++] = x;
        }

        public T Pop()
        {
            if (count == 0)
                throw new Exception("Stack is empty");
            T x = items[--count];
            items[count] = default(T);
            if (count <= items.Length / 4)
                Resize(items.Length / 2);
            return x;
        }

        public T Peek()
        {
            if (count == 0)
                throw new Exception("Stack is empty");
            return items[count - 1];
        }

        public bool IsEmpty
        {
            get
            {
                return count == 0;
            }
        }

        public int Size
        {
            get
            {
                return count;
            }
        }

        public int Capacity
        {
            get
            {
                return items.Length;
            }
            set
            {
                if (value < count)
                    throw new Exception("Capacity is not enough");
                Resize(value);
            }
        }
    }
}
