﻿using System;
using System.Collections;
using System.Collections.Generic;

namespace algocs_stack
{
    // Реализуем интерфейс IEnumerable
    // (в GetEnumerator мы используем yield return и магия компилятора сама создает класс, реализующий IEnumerator)
    class Stack4<T> : IEnumerable<T>
    {
        const int MIN_SIZE = 4;

        int count;
        T[] items;

        public Stack4()
        {
            items = new T[MIN_SIZE];
        }

        public Stack4(int capacity)
        {
            items = new T[capacity];
        }

        private void Resize(int n)
        {
            if (n < MIN_SIZE)
                return;
            T[] temp = new T[n];
            for (int i = 0; i < count; i++)
                temp[i] = items[i];
            items = temp;
        }

        public void Push(T x)
        {
            if (count == items.Length)
                Resize(items.Length * 2);
            items[count++] = x;
        }

        public T Pop()
        {
            if (count == 0)
                throw new Exception("Stack is empty");
            T x = items[--count];
            items[count] = default(T);
            if (count <= items.Length / 4)
                Resize(items.Length / 2);
            return x;
        }

        public T Peek()
        {
            if (count == 0)
                throw new Exception("Stack is empty");
            return items[count - 1];
        }

        public bool IsEmpty
        {
            get
            {
                return count == 0;
            }
        }

        public int Size
        {
            get
            {
                return count;
            }
        }

        public int Capacity
        {
            get
            {
                return items.Length;
            }
            set
            {
                if (value < count)
                    throw new Exception("Capacity is not enough");
                Resize(value);
            }
        }
    
        public IEnumerator<T> GetEnumerator()
        {
 	        for (int index = count - 1; index >= 0; index--)
                yield return items[index];
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
 	        return GetEnumerator();
        }
    }
}
