﻿using System;

namespace algocs_structs
{
    class Program
    {
        // Программа иллюстрирует разницу между class и struct.
        // Определены два практически идентичных типа: Time и TimeStruct,
        // единственное отличие - Time объявлен как class, а TimeStruct - как struct. 
        // В результате имеем: Time - reference type, TimeStruct - value type.
        // Экземпляр Time создается в куче и при передаче в метод передается ссылка.
        // Экземпляр TimeStruct создается в стеке и при передаче в метод копируется значение.

        // Также обратите внимание на использование property в Time/TimeStruct:
        // 1. Hours / Minutes / Seconds реализованы как read-write свойства
        //    с проверкой корректности значений в методе set (бросает
        //    ArgumentException в случае попытки выставить неверное значение)
        // 2. TotalSeconds - вычислимое read-only свойство

        static void Main(string[] args)
        {
            var time = new Time(0, 5, 12);
            Console.WriteLine(time.TotalSeconds);
            time.Hours = 1;
            Console.WriteLine(time.TotalSeconds);

            var time2 = new TimeStruct(0, 5, 12);
            Console.WriteLine(time2.TotalSeconds);
            time2.Hours = 1;
            Console.WriteLine(time2.TotalSeconds);

            ChangeTime(time);
            Console.WriteLine(time.TotalSeconds);
            Console.WriteLine(time);

            ChangeTimeStruct(time2);
            Console.WriteLine(time2.TotalSeconds);
            Console.WriteLine(time2);
        }

        static void ChangeTime(Time time)
        {
            time.Minutes += 2;
        }

        static void ChangeTimeStruct(TimeStruct time)
        {
            time.Minutes += 2;
        }
    }
}
