﻿using System;

namespace algocs_structs
{
    class Time : object
    {
        public Time(int hours, int minutes, int seconds)
        {
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
        }

        private int hours;
        public int Hours
        {
            get { return hours; }
            set
            {
                if (value < 0 || value > 23)
                    throw new ArgumentException("Hours should be in 0-23 range");
                hours = value;
            }
        }

        private int minutes;
        public int Minutes
        {
            get { return minutes; }
            set
            {
                if (value < 0 || value > 59)
                    throw new ArgumentException("Minutes should be in 0-59 range");
                minutes = value;
            }
        }

        private int seconds;
        public int Seconds
        {
            get { return seconds; }
            set
            {
                if (value < 0 || value > 59)
                    throw new ArgumentException("Seconds should be in 0-59 range");
                seconds = value;
            }
        }

        public int TotalSeconds
        {
            get { return hours * 60 * 60 + minutes * 60 + seconds; }
        }

        public override string ToString()
        {
            return string.Format("{0:00}:{1:00}:{2:00}", hours, minutes, seconds);
        }
    }
}
