package algojava;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;

public class Main {

    public static void main(String[] args) {

        // массив объетов типа Person
        Person[] persons = new Person[8];

        persons[0] = new Person("Alan", "Mathison", "Turing", LocalDate.of(1912, 06, 23));
        persons[1] = new Person("Edsger", "Wybe", "Dijkstra", LocalDate.of(1930, 05, 11));
        persons[2] = new Person("Donald", "Ervin", "Knuth", LocalDate.of(1938, 01, 10));
        persons[3] = new Person("Charles", "Antony Richard", "Hoare", LocalDate.of(1934, 01, 11));
        persons[4] = new Person("Robert", "Endre", "Tarjan", LocalDate.of(1948, 04, 30));
        persons[5] = new Person("Claude", "Elwood", "Shannon", LocalDate.of(1916, 04, 30));
        persons[6] = new Person("John", "von", "Neumann", LocalDate.of(1903, 12, 28));
        persons[7] = new Person("Richard", "Manning", "Karp", LocalDate.of(1935, 01, 03));

        // сортируем с использованием дефолтного метода сравнения (Person реализует интерфейс IComparable)
        Arrays.sort(persons);
        for (Person p : persons)
            System.out.println(p);

        System.out.println("-----");

        // сортируем с использованием специального компаратора, чтобы отсортировать по дате рождения
        PersonComparerByDate c = new PersonComparerByDate();
        Arrays.sort(persons, c);
        for (Person p : persons)
            System.out.println(p);

        // наш компаратор еще умеет считать количество сравнений
        System.out.printf("    Количество сравнений: %d\n", c.count());
    }
}
