package algojava;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;

public class Person implements Comparable<Person> {
    private String firstName, secondName, lastName;
    private LocalDate birthDate;
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    public String firstName() {
        return firstName;
    }

    public String secondName() {
        return secondName;
    }

    public String lastName() {
        return lastName;
    }

    public LocalDate birthDate() {
        return birthDate;
    }

    public Person(String firstName, String secondName, String lastName, LocalDate birthDate)
    {
        this.firstName = firstName;
        this.secondName = secondName;
        this.lastName = lastName;
        this.birthDate = birthDate;
    }

    @Override
    public String toString()
    {
        return String.format("%s, %s %s (%s)", lastName, firstName, secondName, birthDate.format(dateFormatter));
    }

    @Override
    public int compareTo(Person o) {
        int cmp = lastName.compareTo(o.lastName);
        if (cmp == 0)
        {
            cmp = firstName.compareTo(o.firstName);
            if (cmp == 0)
                cmp = secondName.compareTo(o.secondName);
        }
        return cmp;
    }
}
