package algojava;

import java.util.Comparator;
import java.util.Date;

// Делаем класс, реализующий интерфейс Comparator
public class PersonComparerByDate implements Comparator<Person> {

    // Компаратор должен реализовать только 1 метод: compare(o1, o2).
    // В этом классе мы дополнительно реализуем подсчет количества выполненных сравнений,
    // что может быть полезно, если мы хотим сравнить разные алгоритмы по количеству сравнений

    @Override
    public int compare(Person o1, Person o2) {
        count++;
        return o1.birthDate().compareTo(o2.birthDate());
    }

    private int count;
    public int count() {
        return count;
    }

    public void reset() {
        count = 0;
    }
}
