// Есть возможность писать класс без package. Но лучше так не делать.
// Название можно выбрать произвольно, обычно составляется в виде
//   доменное имя в перевернутом виде (название компании) + имя продукта
// package ru.msu.math.algojava;
// Но можем использовать и имя попроще
package algojava;

// По использованию import похожа на #include в языке C, хотя и делает нечто совсем иное.
// Мы собираемся использовать класс Scanner, который объявлен в пакете java.util.
// Мы можем импортировать только этот класс:
import java.util.Scanner;
// Мы можем импортировать все классы из этого пакета:
//   import java.util.*;
// Встретив использование типа Scanner в нашем коде, компилятор найдет класс
// с таким именем среди импортированных и будет использовать его.

public class Main {

    // Точка входа: метод main, аналог функции main в языке C:
    //   int main(int argc, char **argv)
    // В Java мы также получаем список аргументов как массив строк.
    public static void main(String[] args) {

        // для ввода-вывода в Java используются объекты
        // System.in, System.out, System.err - аналоги stdin, stdout, stderr
        System.out.println("Hello, world");

        // System.in позволяет читать данные побайтово, что не удобно, если мы хотим
        // прочитать текстовую строку, целое или вещественное число.
        // Для удобного ввода нужно воспользоваться классом Scanner.

        // Определяем переменную типа Scanner.
        // Мы могли бы не использовали директиву import, а использовать
        // полное имя класса (fully qualified name): java.util.Scanner,
        // но это было бы неудобно. Делать так придется, если в одном файле
        // потребуется использовать два класса с одинаковыми именами
        // из разных пакетов.
        Scanner scanner = new Scanner(System.in);
        // Также, как и в языке C, можно совмещать декларацию переменной и ее инициализацию.
        // Здесь мы сразу присваиваем переменной scanner значение - новый созданный
        // объект типа Scanner. При создании мы передаем ему (в конструктор) поток данных,
        // из которого он будет читать данные - System.in.

        // Теперь мы легко можем прочитать строку...
        String s = scanner.nextLine();
        // ...или целое число
        int n = scanner.nextInt();

        // Создадим массив значений int размера n и заполним его, прочитав значения с консоли
        int[] a = new int[n];
        for (int i = 0; i < n; i++)
            a[i] = scanner.nextInt();

        // Выведем то, что мы прочитали. Для вывода можем использовать форматные строки как в зыке C:
        System.out.printf("%s %d\n", s, n);
        for (int i = 0; i < n; i++)
            System.out.printf("%d ", a[i]);
    }
}
