package algojava;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;

public class Main {

    public static void main(String[] args) {

        // учимся сравнивать строки
        String s1 = "Hello";
        String s2 = "Hell";
        s2 = s2 + "o";

        // сравнивать строки с помощью == (как и любые объекты) неправильно
        System.out.printf("s1 == s2: %b\n", s1 == s2);
        System.out.printf("s1.equals(s2): %b\n", s1.equals(s2));

        // когда нужно производить много операций со строкой (складывать куски, брать подстроки, переворачивать...)
        // рекомендуется использовать StringBuilder
        StringBuilder sb = new StringBuilder();
        sb.append("H").append("el").append("lo");
        String s3 = sb.toString();
        System.out.printf("s1 == s3: %b\n", s1 == s3);
        System.out.printf("s1.equals(s3): %b\n", s1.equals(s3));

        // метод intern() возвращает ссылку на строку из пула строк.
        // пул гарантирует, что две строки с одинаковым значением будут представлены одним объектом.
        String s4 = s2.intern();
        System.out.printf("s1 == s4: %b\n", s1 == s4);
        System.out.printf("s1.equals(s4): %b\n", s1.equals(s4));

        // создаем объекты нашего класса
        Person person1 = new Person("Alan", "Mathison", "Turing", LocalDate.of(1912, 06, 23));
        Person person2 = new Person("Edsger", "Wybe", "Dijkstra", LocalDate.of(1930, 05, 11));
        Person person3 = new Person("Donald", "Ervin", "Knuth", LocalDate.of(1938, 01, 10));

        Person personX = new Person("Alan", "Mathison", "Turing", LocalDate.of(1912, 06, 23));

        // добавляем созданные объекты в хеш-таблицу
        HashSet<Person> set = new HashSet<Person>();
        set.add(person1); // в хеш-таблице 1 объект
        set.add(person2); // в хеш-таблице 2 объекта
        set.add(person3); // в хеш-таблице 3 объекта
        set.add(person1); // повторное добавление объекта не изменяет содержимое хеш-таблицы
                          // (по-прежнему 3 объекта)
        set.add(personX); // добавляем еще одного Алана Тьюринга. если equals() и hashCode()
                          // реализованы правильно - содержимое хеш-таблицы не изменится

        for (Person p : set)
            System.out.println(p);

        // придумать строки с одинаковыми хеш-кодами достаточно просто, следовательно, легко
        // подобрать входные данные, которые превратят операции с хеш-таблицей строк из O(1) в O(n)...
        String ss1 = "aaaaaaaaaaaaaa";
        String ss2 = "bBaaaaaaaaaaaa";

        System.out.println(ss1.hashCode());
        System.out.println(ss2.hashCode());
    }
}
