package algojava;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

// Для хранения объектов пользовательского класса в хеш-таблице
// необходимо переопределить методы equals() и hashCode().
// В среде IntelliJ IDEA эти методы можно сгенерить автоматически
// (сочетание клавиш Alt+Insert или пункт меню Code/Generate...)
public class Person implements Comparable<Person> {

    private static DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    private String firstName, secondName, lastName;
    private LocalDate birthDate;

    public String firstName() {
        return firstName;
    }

    public String secondName() {
        return secondName;
    }

    public String lastName() {
        return lastName;
    }

    public LocalDate birthDate() {
        return birthDate;
    }

    public Person(String firstName, String secondName, String lastName, LocalDate birthDate)
    {
        this.firstName = firstName;
        this.secondName = secondName;
        this.lastName = lastName;
        this.birthDate = birthDate;
    }

    @Override
    public String toString()
    {
        return String.format("%s, %s %s (%s)", lastName, firstName, secondName, birthDate.format(dateFormatter));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Person)) return false;

        Person person = (Person) o;

        if (birthDate != null ? !birthDate.equals(person.birthDate) : person.birthDate != null) return false;
        if (firstName != null ? !firstName.equals(person.firstName) : person.firstName != null) return false;
        if (lastName != null ? !lastName.equals(person.lastName) : person.lastName != null) return false;
        if (secondName != null ? !secondName.equals(person.secondName) : person.secondName != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = firstName != null ? firstName.hashCode() : 0;
        result = 31 * result + (secondName != null ? secondName.hashCode() : 0);
        result = 31 * result + (lastName != null ? lastName.hashCode() : 0);
        result = 31 * result + (birthDate != null ? birthDate.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(Person o) {
        int cmp = lastName.compareTo(o.lastName);
        if (cmp == 0)
        {
            cmp = firstName.compareTo(o.firstName);
            if (cmp == 0)
                cmp = secondName.compareTo(o.secondName);
        }
        return cmp;
    }
}
