package algojava;

import javax.swing.text.DateFormatter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Scanner;

public class Main {

    // Первая программа:
    //  1. Ввод-вывод c использованием Scanner, форматированный вывод.
    //  2. Реализация сортировки вставками.
    //  3. Задание значений массива в коде программы.
    //  4. Стандартный метод сортировки массива
    public static void main(String[] args) {

        // ввод данных из консоли или текстового файла удобно осуществлять с помощью класса Scanner
        Scanner scanner = new Scanner(System.in);

        // спрашиваем имя пользователя и приветсвуем его
        System.out.print("What is your name? ");
        String name = scanner.next();
        System.out.printf("Hello, %s!\n", name);

        // простой неформатированный вывод
        System.out.print(17);
        System.out.print(" - ");
        System.out.println(357.6279);

        // форматированный вывод в Java аналогичен C
        System.out.printf("Целое: %d - Вещественное с 2 знаками после запятой: %.2f\n", 17, 357.6279);
        // можно форматировать строки для дальнейшего использования в программе
        String text = String.format("%d^2 + %d^2 = %d^2", 3, 4, 5);
        System.out.println(text);

        // для форматирования даты/времени используется специальный класс

        // Date - устаревший класс, в Java8 предлагается использовать LocalDate
        // (в предыдущих версиях - библиотеку joda time: http://www.joda.org/joda-time/ )

        //DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        //Date date = new Date();
        //System.out.println(dateFormat.format(date));

        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
        LocalDateTime dateTime = LocalDateTime.now();
        System.out.println(dateTime.format(dateTimeFormatter));

        // считываем размер массива
        System.out.print("Введите размер массива: ");
        int n = scanner.nextInt();

        // считываем элементы массива
        System.out.printf("Введите %d целых чисел: \n", n);
        int[] a = new int[n];
        for (int i = 0; i < n; i++)
            a[i] = scanner.nextInt();

        // вызываем метод сортировки (сортировка вставками) и выводим отсортированный массив
        Sort(a);
        for (int i = 0; i < a.length; i++)
            System.out.printf("%d ", a[i]);
        System.out.println();

        // задаем массив строк в программе
        String[] b = new String[] { "One", "Two", "Three", "Четыре", "Пять", "Шесть", "Seven", "Eight" };

        // сортируем стандартным методом (в алфавитном порядке) и выводим отсортированный массив
        Arrays.sort(b);
        for (int i = 0; i < b.length; i++)
            System.out.printf("%s ", b[i]);
        System.out.println();
    }

    private static void Sort(int[] a)
    {
        int N = a.length;
        for (int i = 1; i < N; i++)
        {
            int j = i, t = a[j];
            while (j > 0 && t < a[j - 1])
            {
                a[j] = a[j - 1];
                j--;
            }
            a[j] = t;
        }
    }
}
