package algojava;

// Реализация стека как обобщенного типа (generic),
// т.е. контейнера, способного хранить элементы указанного типа T

// Обратите внимание на присваивание null элементу массива в методе pop().
// Это необходимо для избежания утечки памяти (memory leak).
public class Stack2<T> {

    private static final int MIN_SIZE = 4;

    private T[] values;
    private int count;

    public Stack2() {
        values = (T[])new Object[MIN_SIZE];
    }

    private void resize(int N) {
        T[] newValues = (T[])new Object[N];
        for (int i = 0; i < count; i++)
            newValues[i] = values[i];
        values = newValues;
    }

    public void push(T x) {
        if (count == values.length)
            resize(2 * values.length);
        values[count++] = x;
    }

    public T pop() {
        if (count == 0)
            throw new RuntimeException("Stack is empty");

        T x = values[--count];
        values[count] = null;
        if (count < values.length / 4 && count > MIN_SIZE)
            resize(values.length / 2);
        return x;
    }

    public int count() {
        return count;
    }

    public boolean isEmpty() {
        return count == 0;
    }

    public T peek() {
        if (count == 0)
            throw new RuntimeException("Stack is empty");

        return values[count - 1];
    }

    public void clear() {
        count = 0;
        resize(MIN_SIZE);
    }

    public int getCapacity() {
        return values.length;
    }

    public void setCapacity(int value) {
        if (count > value)
            throw new RuntimeException("Capacity is not enough");
        resize(value);
    }
}
