package algojava;

// Реализация стека int на основе массива
public class Stack1 {

    private static final int MIN_SIZE = 4;

    private int[] values;
    private int count;

    public Stack1() {
        values = new int[MIN_SIZE];
    }

    private void resize(int N) {
        int[] newValues = new int[N];
        for (int i = 0; i < count; i++)
            newValues[i] = values[i];
        values = newValues;
    }

    public void push(int x) {
        if (count == values.length)
            resize(2 * values.length);
        values[count++] = x;
    }

    public int pop() {
        if (count == 0)
            throw new RuntimeException("Stack is empty");

        int x = values[--count];
        if (count < values.length / 4 && count > MIN_SIZE)
            resize(values.length / 2);
        return x;
    }

    public int count() {
        return count;
    }

    public boolean isEmpty() {
        return count == 0;
    }

    public int peek() {
        if (count == 0)
            throw new RuntimeException("Stack is empty");

        return values[count - 1];
    }

    public void clear() {
        count = 0;
        resize(MIN_SIZE);
    }

    public int getCapacity() {
        return values.length;
    }

    public void setCapacity(int value) {
        if (count > value)
            throw new RuntimeException("Capacity is not enough");
        resize(value);
    }
}
