package algojava;

import java.util.Iterator;

// Реализуем интерфейс Iterable
// В методе iterator() мы возвращаем inner класс, реализующий Iterator.
// Обратите внимание: в Java экземпляр внутреннего класса содержит ссылку на экземпляр внешнего класса.
// По этой причине 1) в методах внутреннего класса можно обращаться к полям внешнего;
// 2) создать экземпляр внутреннего класса можно только в методах экземпляра внешнего класса
// (а например в статических методах этого сделать нельзя).
public class Stack3<T> implements Iterable<T> {

    private static final int MIN_SIZE = 4;

    private T[] values;
    private int count;

    public Stack3() {
        values = (T[])new Object[MIN_SIZE];
    }

    private void resize(int N) {
        T[] newValues = (T[])new Object[N];
        for (int i = 0; i < count; i++)
            newValues[i] = values[i];
        values = newValues;
    }

    public void push(T x) {
        if (count == values.length)
            resize(2 * values.length);
        values[count++] = x;
    }

    public T pop() {
        if (count == 0)
            throw new RuntimeException("Stack is empty");

        T x = values[--count];
        values[count] = null;
        if (count < values.length / 4 && count > MIN_SIZE)
            resize(values.length / 2);
        return x;
    }

    public int count() {
        return count;
    }

    public boolean isEmpty() {
        return count == 0;
    }

    public T peek() {
        if (count == 0)
            throw new RuntimeException("Stack is empty");

        return values[count - 1];
    }

    public void clear() {
        count = 0;
        resize(MIN_SIZE);
    }

    public int getCapacity() {
        return values.length;
    }

    public void setCapacity(int value) {
        if (count > value)
            throw new RuntimeException("Capacity is not enough");
        resize(value);
    }

    class StackIterator implements Iterator<T>
    {
        private int index = count;

        @Override
        public boolean hasNext() {
            return index > 0;
        }

        @Override
        public T next() {
            return values[--index];
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new StackIterator();
    }
}
